import gc
import board
import displayio
from adafruit_display_shapes.circle import Circle
import terminalio
import adafruit_ili9341
import vectorio

# Release any resources currently in use for the displays
displayio.release_displays()

spi = board.SPI()
tft_cs = board.D9
tft_dc = board.D10

display_bus = displayio.FourWire(spi, command=tft_dc, chip_select=tft_cs, reset=board.D6)
display = adafruit_ili9341.ILI9341(display_bus, width=320, height=240, rotation=180)

# Make the display context
splash = displayio.Group()
display.show(splash)

# Make a background "bg" color fill
color_bitmap = displayio.Bitmap(320, 240, 1)
color_palette = displayio.Palette(1)
color_palette[0] = 0xFFFFFF
bg_sprite = displayio.TileGrid(color_bitmap, x=0, y=0, pixel_shader=color_palette)
splash.append(bg_sprite)

#Draw the record_pause_state circle:
palette = displayio.Palette(1)
palette[0] = 0xC1C1C1
record_pause_circle = vectorio.Circle( pixel_shader=palette, radius=45, x=170, y=70 )
splash.append( record_pause_circle )

while True:
    pass
